import * as React from 'react';
import { get } from 'api/common';
import Mail from 'components/Mail';
import SenderMailStatus from './SenderMailStatus';
import css from './SenderMail.scss';

interface Props {
  id: number;
  show: boolean;
}

interface Mail {
  clickCount?: number;
  showCount?: number;
}

interface State {
  data: Mail | null;
}

class SenderMail extends React.Component<Props, State> {
  private request: any;

  public state: State = {
    data: null,
  };

  public componentDidMount() {
    this.load();
  }

  public componentDidUpdate() {
    this.load();
  }

  public componentWillUnmount() {
    if (this.request) {
      this.request.cancel();
    }
  }

  private load() {
    if (this.props.show && !this.request && !this.state.data) {
      this.request = get({
        url: '/view/sender/mail',
        data: { id: this.props.id },
      })
        .then(data => {
          this.request = null;
          this.setState({ data });
          return data;
        })
        .catch(e => {
          this.request = null;
          throw e;
        });
    }
  }

  public render() {
    if (!this.props.show || !this.state.data) {
      return null;
    }

    const { clickCount, showCount, ...other } = this.state.data;

    return (
      <Mail
        {...other}
        {...this.props}
        className={css.b}
        date=""
        showMeta
        extraMeta={<SenderMailStatus clickCount={clickCount} showCount={showCount} />}
      />
    );
  }
}

export default SenderMail;
