import React from 'react';
import Icon from 'lego/components/Icon';
import createI18N from '@yandex-int/i18n';
import * as keyset from '../HistoryItems.i18n';

const i18n = createI18N(keyset);
const i18nMailWasOpened = i18n('mailWasOpened');
const i18nWasClickedOnLink = i18n('wasClickedOnLink');

const SenderMailStatus = props => {
  const { clickCount, showCount } = props;

  return (
    <span>
      <span title={i18nMailWasOpened}>
        <Icon pack={Icon.PACKS.FONTAWESOME} icon="eye" />
        &nbsp;
        {showCount || 0}
      </span>
      &nbsp; &nbsp;
      <span title={i18nWasClickedOnLink}>
        <Icon pack={Icon.PACKS.FONTAWESOME} icon="hand-o-up" />
        &nbsp;
        {clickCount || 0}
      </span>
    </span>
  );
};

export default SenderMailStatus;
