import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { Icon } from 'modules/massmail';
import cssMail from '../MailClientHistory/styles.modules.scss';
import ItemDate from '../ItemDate';
import ItemColumnDate from '../ItemColumnDate';
import ItemColumn from '../ItemColumn';
import ItemWrap from '../ItemWrap';
import ItemHeader from '../ItemHeader';
import ItemIcon from '../ItemIcon';
import SenderMail from './SenderMail';

const SenderMailHistory = ({
  toggle,
  onToggle,
  item,
  data: { hasAttach, id, date, subject, from },
}) => (
  <ItemWrap isOpen={toggle}>
    <ItemHeader onClick={onToggle}>
      <ItemIcon type="Ticket">
        <Icon />
        {hasAttach && <i className={cx('material-icons', cssMail.icon_attach)}>attach_file</i>}
      </ItemIcon>
      <ItemColumn title={from} subTitle={subject} />
      <ItemColumnDate item={item}>
        <ItemDate date={date} />
      </ItemColumnDate>
    </ItemHeader>
    <SenderMail id={id} className={cssMail.mail} show={toggle} />
  </ItemWrap>
);

SenderMailHistory.propTypes = {
  toggle: PropTypes.bool,
  onToggle: PropTypes.func.isRequired,
  item: PropTypes.instanceOf(Object),
  data: PropTypes.instanceOf(Object),
};

SenderMailHistory.defaultProps = {
  item: undefined,
  data: {},
  toggle: false,
};

export default SenderMailHistory;
