import React, { PureComponent } from 'react';
import Icon from 'components/Icons/Icon';
import { CallIconProps } from './CallIcon.types';
import { ICON_CONFIG } from '../YcCallItem.constants';

export default class CallIcon extends PureComponent<CallIconProps> {
  render() {
    const { type, ...passPropsThrough } = this.props;
    const iconConfig = ICON_CONFIG[type];

    if (!iconConfig) {
      return null;
    }

    const { pack, icon } = iconConfig;

    return <Icon pack={pack} icon={icon} {...passPropsThrough} />;
  }
}
