import { connect } from 'react-redux';
// TODO: https://st.yandex-team.ru/CRM-10561
import { isTestMode } from 'modules/issues/redux/createSelectors';
import { fetchYcCall, fetchPersonalYcCall } from '../../../../actions';
import { getYcCall, fetchingYcCall, getYcCategorization } from '../../../../selectors';
import FullInfo from './FullInfo';

import {
  FullInfoConnectedStateProps,
  FullInfoConnectedDispatchProps,
  FullInfoOwnProps,
} from './FullInfo.types';

const mapStateToProps = (state, ownProps: FullInfoOwnProps): FullInfoConnectedStateProps => ({
  call: getYcCall(ownProps.id, state),
  categorization: getYcCategorization(ownProps.id, state),
  fetching: fetchingYcCall(ownProps.id, state),
  isTest: isTestMode(state),
});

const mapDispatchToProps = (dispatch): FullInfoConnectedDispatchProps => ({
  fetchCall: (issueId: number, id: number) => {
    dispatch(fetchYcCall(issueId, id));
  },
  fetchPersonalCall: (activityId: number) => {
    dispatch(fetchPersonalYcCall(activityId));
  },
});

export default connect<
  FullInfoConnectedStateProps,
  FullInfoConnectedDispatchProps,
  FullInfoOwnProps
>(
  mapStateToProps,
  mapDispatchToProps,
)(FullInfo);
