import React, { PureComponent, ReactNode } from 'react';
import Spin from '@crm/components/dist/lego2/Spin';
import CallInfo from 'modules/issues/components/Timeline/Call/CallInfo';
import { FullInfoProps } from './FullInfo.types';
import css from './FullInfo.module.css';

export default class FullInfo extends PureComponent<FullInfoProps> {
  componentDidMount(): void {
    const { fetchCall, fetchPersonalCall, id, isPersonal, issueId } = this.props;

    if (isPersonal) {
      fetchPersonalCall(id);
    } else {
      fetchCall(issueId!, id);
    }
  }

  render(): ReactNode {
    const { call, categorization, fetching, isTest, isPersonal } = this.props;
    if (!fetching && !call) {
      return null;
    }
    return (
      <div className={css.b}>
        {fetching ? (
          <Spin progress view="default" size="xxs" />
        ) : (
          <CallInfo
            isTest={isTest}
            view={isPersonal ? 'accountHistoryPersonal' : 'accountHistory'}
            call={call}
            categorization={categorization}
          />
        )}
      </div>
    );
  }
}
