import { Call } from 'types/entities/call';
import { Categorization } from 'types/entities/categorization';
export { Call };

export interface FullInfoConnectedStateProps {
  fetching: boolean;
  categorization: Categorization;
  call: Call;
  isTest: boolean;
}

export interface FullInfoConnectedDispatchProps {
  fetchCall: (issueId: number, id: number) => void;
  fetchPersonalCall: (activityId: number) => void;
}

export type FullInfoConnectedProps = FullInfoConnectedStateProps & FullInfoConnectedDispatchProps;

export interface FullInfoOwnProps {
  id: number;
  issueId?: number;
  isPersonal?: boolean;
}

export type FullInfoProps = FullInfoConnectedProps & FullInfoOwnProps;
