import React, { PureComponent } from 'react';
import LinkModule from 'components/LinkModule';
import ItemDate from 'modules/clientHistory/components/HistoryItems/ItemDate';
import ItemColumn from 'modules/clientHistory/components/HistoryItems/ItemColumn';
import ItemBadge from 'modules/clientHistory/components/HistoryItems/ItemBadge';
import ItemIcon from 'modules/clientHistory/components/HistoryItems/ItemIcon';
import PlainText from 'components/PlainText';
import { TagListWithAdapter } from 'components/TagList';
import ItemColumnDate from 'modules/clientHistory/components/HistoryItems/ItemColumnDate';
import ItemWrap from 'modules/clientHistory/components/HistoryItems/ItemWrap';
import ItemHeader from 'modules/clientHistory/components/HistoryItems/ItemHeader';
import Name from 'components/Name';
import backendTypes from 'constants/backendTypes';
import CallIcon from './CallIcon';
import css from './YcCallItem.module.css';
import { YcCallItemProps, Categorization } from './YcCallItem.types';
import { CallIconProps } from './CallIcon/CallIcon.types';
import FullInfo from './FullInfo';
import { DIRECTION_ICON } from './YcCallItem.constants';

class YcCallItem extends PureComponent<YcCallItemProps> {
  private getCallIcon = (props: CallIconProps) => {
    const { item } = this.props;
    return <CallIcon {...props} type={DIRECTION_ICON[item.call.direction]} />;
  };

  private getCategoriesAsString = (categorization?: Categorization): string => {
    if (categorization === undefined) {
      return '';
    }
    return `Категории: ${categorization.categories.map((category) => category.name).join(', ')}`;
  };

  private get isPersonal() {
    return this.props.item.parent.type === 'ManagerActivity';
  }

  private renderDate = () => {
    const { item } = this.props;

    if (this.isPersonal) {
      return <ItemDate date={item.date} />;
    }

    const entityData = {
      parentTypeId: item.parent.issue!.typeId,
      parentId: item.parent.id,
      eType: item.type,
      entityId: item.id,
    };

    return (
      <LinkModule
        type={backendTypes.YcCALL}
        id={item.parent.id}
        entityData={entityData}
        isStopPropagation
      >
        <ItemDate date={item.date} />
      </LinkModule>
    );
  };

  render(): React.ReactNode {
    const { toggle, onToggle, item } = this.props;

    return (
      <ItemWrap isOpen={toggle}>
        <div className={css.CallHistoryItem__headerWrap} onClick={onToggle}>
          <ItemHeader>
            <ItemIcon type="Call" supIcon={this.getCallIcon} />
            <ItemColumn
              title={
                <span>Звонок&nbsp; {item.call.hasFactors && <ItemBadge type="Upsale" />}</span>
              }
              subTitle={this.getCategoriesAsString(item.call.categorization)}
            />
            <ItemColumn
              title={item.call.author.name ? <Name name={item.call.author.name} /> : null}
            />
            <ItemColumnDate item={item}>{this.renderDate()}</ItemColumnDate>
          </ItemHeader>
          {!toggle && item.call.comment && (
            <PlainText className={css.CallHistoryItem__dataRow} text={item.call.comment} link />
          )}
          {!toggle && Array.isArray(item.call.tags) && Boolean(item.call.tags.length) && (
            <TagListWithAdapter
              className={css.CallHistoryItem__dataRow}
              tags={item.call.tags}
              data-testid="tags"
            />
          )}
        </div>
        {toggle &&
          (this.isPersonal ? (
            <FullInfo id={item.parent.id} isPersonal />
          ) : (
            <FullInfo id={item.call.id} issueId={item.parent.id} />
          ))}
      </ItemWrap>
    );
  }
}

export default YcCallItem;
