import { CallHistoryItem as CallHistory } from 'modules/phone';
import { ISSUE_TYPES } from 'constants/backendTypes';
import ST from './STHistory';
import SenderMail from './SenderMail';
import MassmailHistory from './MassmailHistory';
import MailClientHistory from './MailClientHistory';
import CommentClientHistory from './CommentClientHistory';
import ChatHistory from './ChatHistory';
import IssueHistory from './IssueHistory';
import YcCallItem from './YcCallItem';
export default {
  Call: {
    dataKey: 'call',
    component: CallHistory,
  },
  YcCall: {
    dataKey: 'YcCall',
    component: YcCallItem,
  },
  PersonalMail: {
    dataKey: 'personalMail',
    component: MailClientHistory,
  },
  Massmail: {
    dataKey: 'massmail',
    component: MassmailHistory,
  },
  SenderMail: {
    dataKey: 'senderMail',
    component: SenderMail,
  },
  AccountComment: {
    dataKey: 'accountComment',
    component: CommentClientHistory,
  },
  AccountSt: {
    dataKey: 'accountSt',
    component: ST,
  },
  ChatChunk: {
    dataKey: 'chatChunk',
    component: ChatHistory,
  },
  [ISSUE_TYPES.TASK]: {
    dataKey: 'issue',
    component: IssueHistory,
  },
  [ISSUE_TYPES.APPROVAL]: {
    dataKey: 'issue',
    component: IssueHistory,
  },
  IssueTicket: {
    dataKey: 'issue',
    component: IssueHistory,
  },
  Issue: {
    dataKey: 'issue',
    component: IssueHistory,
  },
};
