import React from 'react';
import hoistNonReactStatic from 'hoist-non-react-statics';

const toggle = WrappedComponent => {
  class Toggle extends React.Component {
    constructor(props) {
      super(props);
      this.state = {
        toggle: false,
      };
    }

    toggle = () => {
      if (this.state.toggle) {
        this.setState({ toggle: false });
      } else {
        this.setState({ toggle: true });
      }
    };

    render() {
      return <WrappedComponent {...this.props} onToggle={this.toggle} toggle={this.state.toggle} />;
    }
  }

  hoistNonReactStatic(Toggle, WrappedComponent);
  return Toggle;
};

export default toggle;
