import Immutable from 'immutable';
import * as t from './actions';

const INIT_STATE = {
  itemsMap: {},
  panel: null,
  withFilters: true,
  showFilters: true,
  YcCalls: {},
};

export default (state = INIT_STATE, action) => {
  let newState;
  let id;
  let fetching;
  switch (action.type) {
    case t.SET_PANEL:
      return { ...state, panel: action.data };

    case t.TOGGLE_ITEM:
      newState = Immutable.fromJS(state);
      return newState.updateIn(['itemsMap', action.data], (show) => !show).toJS();

    case t.RESET:
    case 'LOCAL_STORAGE':
      return {
        ...INIT_STATE,
        filter: state.filter,
        withFilters: state.withFilters,
        showFilters: state.showFilters,
      };

    case t.TOGGLE_WITH_FILTERS:
      return { ...state, withFilters: !state.withFilters };

    case t.TOGGLE_SHOW_FILTERS:
      return { ...state, showFilters: !state.showFilters };

    case t.SAVE_FILTER:
      return { ...state, filter: action.payload };

    case t.SET_FETCHING_YC_CALL:
      id = action.payload.id;
      fetching = action.payload.fetching;
      return {
        ...state,
        YcCalls: {
          ...state.YcCalls,
          [id]: { ...state.YcCalls[id], fetching },
        },
      };

    case t.ADD_YC_CALL:
      id = action.payload.call.id;
      return {
        ...state,
        YcCalls: {
          ...state.YcCalls,
          [id]: action.payload,
        },
      };

    default:
      return state;
  }
};
