import mapValues from 'lodash/mapValues';

const filterDataForBackend = values =>
  mapValues(values, value => {
    // eslint-disable-next-line no-underscore-dangle
    if (typeof value === 'object' && value._DATA_TYPE === 'TREE_SELECT') {
      if (Array.isArray(value.selectedArrayOptimized) && value.selectedArrayOptimized.length) {
        return value.selectedArrayOptimized;
      }

      return undefined;
    }

    if (typeof value === 'string' && !value) {
      return undefined;
    }

    return value;
  });

export default (values = {}, withFilters) => {
  let newValues;
  if (withFilters) {
    newValues = filterDataForBackend(values);
    if (Array.isArray(newValues.tagIds)) {
      if (newValues.tagIds.length) {
        newValues.tagIds = newValues.tagIds.map(tag => tag.id);
      } else {
        delete newValues.tagIds;
      }
    }
  } else {
    newValues = { text: values.text };
  }

  return newValues;
};
