import React from 'react';
import { formPropTypes } from 'redux-form';
import { Row, Message } from 'forms/Base';
import Button from '@crm/components/dist/lego2/Button';
import Form from 'components/Form';

const ClientMoveForm = (props) => {
  const { onCancel, valid, submitting, handleSubmit } = props;

  return (
    <Form theme={Form.THEME.MODAL} onSubmit={handleSubmit}>
      <Form.Header>Перенести историю</Form.Header>
      <Form.Body>
        <Row component="client" name="account" label="Перенести в" required />
        <Message>История коммуникаций будет перенесена в течение часа</Message>
      </Form.Body>
      <Form.Footer>
        <Button size="m" type="submit" disabled={!valid || submitting} view="action">
          Сохранить
        </Button>
        <Button size="m" onClick={onCancel}>
          Отменить
        </Button>
      </Form.Footer>
    </Form>
  );
};

ClientMoveForm.propTypes = {
  ...formPropTypes,
};

export default ClientMoveForm;
