import { connect } from 'react-redux';
import { reduxForm } from 'redux-form';
import { push } from 'modules/notificationsUI/actions';
import { saveClient } from './api';
import Form from './Form';

const validate = values => {
  const errors = {};
  const requiredFields = ['account'];

  requiredFields.forEach(field => {
    if (!values[field]) {
      errors[field] = 'Обязательно для заполнения';
    }
  });

  return errors;
};

const ClientMoveForm = reduxForm({ validate })(Form);

export default connect(
  null,
  (dispatch, props) => ({
    onSubmit: data => {
      const sendData = { accountIdTo: data.account.id, accountIdFrom: props.accountIdFrom };

      saveClient(sendData).then(response => {
        if (response.success === true) {
          dispatch(push({ theme: 'success', text: response.message }));
          if (typeof props.onSubmit === 'function') {
            props.onSubmit(response.account);
          }
        }

        return response;
      });
    },
  }),
)(ClientMoveForm);
