import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Select from '@crm/components/dist/lego2/Select';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import RowAccount from 'pages/accounts/modules/table/components/RowAccount';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Empty from 'components/Empty';
import Toolbar from 'components/Toolbar';
import { InfiniteTableView } from 'containers/InfiniteList';
import * as keyset from './clientSelectForm.i18n';
import css from './styles.scss';
import tableCss from './table.modules.scss';
import config from './config';
import { VIEW } from './constants';

const i18n = createI18N(keyset);
const i18nSearchBy = i18n('searchBy');
const i18nAccountType = i18n('accountType');
const i18nValue = i18n('value');
const i18nSearchButton = i18n('searchButton');
const i18nNewClient = i18n('newClient');
const i18nChoose = createI18N(commonKeyset)('choose');
const i18nCancel = i18n('cancel');

class Form extends Component {
  handleKeyUpSearchText = (e) => {
    if (e.key === 'Enter') {
      this.props.onSearchClick();
    }

    e.stopPropagation();
  };

  handleSubmit = (e) => {
    if (e.key === 'Enter' && this.props.valid) {
      this.props.onSubmit();
    }
  };

  stopPropagation = (event) => {
    event.stopPropagation();
  };

  render() {
    const {
      searchText,
      searchKey,
      accountType,
      selectedClientId,
      isNewClient,
      valid,
      view,
      newClient,
      disabledAccountType,
      disabledKeys,

      onChangeSearchText,
      onChangeSearchKey,
      onChangeAccountType,
      onSelectClientClick,
      onSelectClientChange,
      onSearchClick,
      onNewClient,
      onLoad,
      onCancel,
      onSubmit,
      itemKey,
    } = this.props;
    const settings = config[view];

    return (
      <div role="presentation" className={css.form} onKeyUp={this.handleSubmit}>
        <div className={css.header}>
          <div className={css.filters}>
            <label className={css.searchKey}>
              <span className={css.searchLabel}>{i18nSearchBy}</span>
              <div>
                <Select
                  value={Array.isArray(searchKey) ? searchKey : [searchKey]}
                  hasEmptyValue={false}
                  size="m"
                  onChange={onChangeSearchKey}
                  width="max"
                  resetItem={config.default.resetItem}
                  disabled={disabledKeys}
                  options={settings.searchKeys.list.map((key) => ({
                    value: key,
                    content: settings.searchKeys.map[key],
                  }))}
                />
              </div>
            </label>
            <label className={css.accountType}>
              <span className={css.searchLabel}>{i18nAccountType}</span>
              <div>
                <Select
                  value={Array.isArray(accountType) ? accountType : [accountType]}
                  hasEmptyValue={false}
                  size="m"
                  width="max"
                  onChange={onChangeAccountType}
                  disabled={disabledAccountType}
                  options={settings.accountTypes.list.map((key) => ({
                    value: key,
                    content: settings.accountTypes.map[key],
                  }))}
                />
              </div>
            </label>
          </div>
          <label className={css.searchVal}>
            <span className={css.searchLabel}>{i18nValue}</span>
            <span className={css.searchInput}>
              <Textinput
                size="m"
                pin="round-clear"
                value={searchText}
                onChange={onChangeSearchText}
                onKeyUp={this.handleKeyUpSearchText}
                autoFocus
              />
              <Button size="m" view="action" pin="brick-round" onClick={onSearchClick}>
                {i18nSearchButton}
              </Button>
            </span>
          </label>
        </div>
        <InfiniteTableView
          onLoad={onLoad}
          name="clientSearch"
          grid={settings.grid}
          flexRatio={settings.flexRatio}
          className={tableCss.body}
          selectedId={selectedClientId}
          onChange={onSelectClientChange}
          onItemClick={onSelectClientClick}
          onItemDoubleClick={onSubmit}
          columnVisibility={settings.displayColumns}
          emptyComponent={Empty}
          rowComponent={RowAccount}
          showIfEmpty
          autoSelectFirst
          focusOnSelectFirst
          itemKey={itemKey}
        />
        <div className={css.footer}>
          {newClient && (
            <span className={css.footer__emptyClient}>
              <Checkbox size="m" checked={isNewClient} onChange={onNewClient}>
                {i18nNewClient}
              </Checkbox>
            </span>
          )}
          <Toolbar reverse className={css.footer__actions}>
            <Button size="m" view="action" disabled={!valid} onClick={onSubmit}>
              {i18nChoose}
            </Button>
            <Button size="m" onClick={onCancel} onKeyUp={this.stopPropagation}>
              {i18nCancel}
            </Button>
          </Toolbar>
        </div>
      </div>
    );
  }
}

Form.VIEW = VIEW;
Form.defaultProps = {
  view: VIEW.DEFAULT,
  newClient: true,
  searchText: '',
  searchKey: undefined,
  accountType: undefined,
  selectedClientId: undefined,
  isNewClient: false,
  disabledAccountType: false,
  disabledKeys: false,
  valid: true,
};

Form.propTypes = {
  searchText: PropTypes.string,
  searchKey: PropTypes.string,
  accountType: PropTypes.string,
  selectedClientId: PropTypes.number,
  isNewClient: PropTypes.bool,
  valid: PropTypes.bool,
  view: PropTypes.string,
  newClient: PropTypes.bool,
  disabledAccountType: PropTypes.bool,
  disabledKeys: PropTypes.bool,

  onChangeSearchText: PropTypes.func.isRequired,
  onChangeSearchKey: PropTypes.func.isRequired,
  onChangeAccountType: PropTypes.func.isRequired,
  onSelectClientClick: PropTypes.func.isRequired,
  onSelectClientChange: PropTypes.func.isRequired,
  onSearchClick: PropTypes.func.isRequired,
  onNewClient: PropTypes.func.isRequired,
  onLoad: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
  onSubmit: PropTypes.func.isRequired,
  itemKey: PropTypes.func.isRequired,
};

export default Form;
