import createI18N from '@yandex-int/i18n';
import * as keyset from './clientSelectForm.i18n';

const i18n = createI18N(keyset);

const i18nGridFoundBy = i18n('gridFoundBy');
const i18nGridType = i18n('gridType');
const i18nGridAccountId = i18n('gridAccountId');
const i18nGridClientId = i18n('gridClientId');
const i18nGridName = i18n('gridName');
const i18nGridLogin = i18n('gridLogin');
const i18nGridAgency = i18n('gridAgency');
const i18nGridDomain = i18n('gridDomain');
const i18nQuantityCurrentMonth = i18n('gridQuantityCurrentMonth');
const i18nGridEmail = i18n('gridEmail');
const i18nGridManager = i18n('gridManager');

const i18nSearchAccountId = i18n('searchAccountId');
const i18nSearchCurrency = i18n('searchCurrency');
const i18nSearchCampaignId = i18n('searchCampaignId');
const i18nSearchBannerId = i18n('searchBannerId');
const i18nSearchBannerGroupId = i18n('searchBannerGroupId');
const i18nSearchLogin = i18n('searchLogin');
const i18nSearchMetrikaLogin = i18n('searchMetrikaLogin');
const i18nSearchName = i18n('searchName');
const i18nSearchMarketCampaignId = i18n('searchMarketCampaignId');
const i18nSearchShopId = i18n('searchShopId');
const i18nSearchDomain = i18n('searchDomain');
const i18nSearchEmail = i18n('searchEmail');
const i18nSearchPhoneNum = i18n('searchPhoneNum');
const i18nSearchInvoiceNum = i18n('searchInvoiceNum');
const i18nSearchInn = i18n('searchInn');
const i18nSearchContractNum = i18n('searchContractNum');
const i18nSearchClientId = i18n('searchClientId');
const i18nSearchTelContractNum = i18n('searchTelContractNum');
const i18nSearchTelPhoneNum = i18n('searchTelPhoneNum');
const i18nSearchZenId = i18n('searchZenId');
const i18nSearchAny = i18n('searchAny');
const i18nSearchRsyaSspBundleId = i18n('searchRsyaSspBundleId');
const i18nSearchRsyaSspPageId = i18n('searchRsyaSspPageId');
const i18nSearchRsyaSspLoginPi = i18n('searchRsyaSspLoginPi');

const i18nAccAny = i18n('accAny');
const i18nAccClient = i18n('accClient');
const i18nAccSubclient = i18n('accSubclient');
const i18nAccAgency = i18n('accAgency');
const i18nAccLead = i18n('accLead');
const i18nAccContractor = i18n('accContractor');
const i18nAccPartner = i18n('accPartner');
const i18nAccTelephony = i18n('accTelephony');
const i18nAccMetrika = i18n('accMetrika');

export default {
  default: {
    displayColumns: {
      clientId: true,
      id: true,
      searchKeyName: true,
      type: true,
      agency: true,
      name: true,
      login: true,
      domain: true,
      w0Total: true,
      email: true,
      manager: true,
    },
    grid: {
      columns: [
        { name: 'searchKeyName', title: i18nGridFoundBy },
        { name: 'type', title: i18nGridType },
        { name: 'id', title: i18nGridAccountId },
        { name: 'clientId', title: i18nGridClientId },
        { name: 'name', title: i18nGridName },
        { name: 'login', title: i18nGridLogin },
        { name: 'agency', title: i18nGridAgency },
        { name: 'domain', title: i18nGridDomain },
        { name: 'w0Total', title: i18nQuantityCurrentMonth },
        { name: 'email', title: i18nGridEmail },
        { name: 'manager', title: i18nGridManager },
      ],
    },
    flexRatio: {
      id: 1,
      agency: 1,
      default: 2,
    },
    searchKeys: {
      map: {
        clientId: i18nSearchClientId,
        accountId: i18nSearchAccountId,
        currency: i18nSearchCurrency,
        campaignId: i18nSearchCampaignId,
        bannerId: i18nSearchBannerId,
        bannerGroupId: i18nSearchBannerGroupId,
        login: i18nSearchLogin,
        loginMetrika: i18nSearchMetrikaLogin,
        name: i18nSearchName,
        marketCampaignId: i18nSearchMarketCampaignId,
        shopId: i18nSearchShopId,
        domain: i18nSearchDomain,
        email: i18nSearchEmail,
        phoneNumber: i18nSearchPhoneNum,
        invoiceNum: i18nSearchInvoiceNum,
        inn: i18nSearchInn,
        contractNum: i18nSearchContractNum,
        yaTelephonyContractNumber: i18nSearchTelContractNum,
        yaTelephonyPhoneNumber: i18nSearchTelPhoneNum,
        rsyaSspLoginPi: i18nSearchRsyaSspLoginPi,
        rsyaSspBundleId: i18nSearchRsyaSspBundleId,
        rsyaSspPageId: i18nSearchRsyaSspPageId,
        zenPublisherId: i18nSearchZenId,
        text: i18nSearchAny,
      },
      list: [
        'text',
        'clientId',
        'accountId',
        'currency',
        'campaignId',
        'bannerId',
        'bannerGroupId',
        'login',
        'loginMetrika',
        'name',
        'marketCampaignId',
        'shopId',
        'domain',
        'email',
        'phoneNumber',
        'invoiceNum',
        'inn',
        'contractNum',
        'yaTelephonyContractNumber',
        'yaTelephonyPhoneNumber',
        'rsyaSspLoginPi',
        'rsyaSspBundleId',
        'rsyaSspPageId',
        'zenPublisherId',
      ],
    },
    resetItem: 'text',
    accountTypes: {
      map: {
        any: i18nAccAny,
        client: i18nAccClient,
        subClient: i18nAccSubclient,
        agency: i18nAccAgency,
        lead: i18nAccLead,
        contractor: i18nAccContractor,
        partner: i18nAccPartner,
        yaTelephony: i18nAccTelephony,
        metrika: i18nAccMetrika,
      },
      list: [
        'any',
        'client',
        'subClient',
        'agency',
        'lead',
        'contractor',
        'partner',
        'yaTelephony',
        'metrika',
      ],
    },
  },
};
