import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Select from '@crm/components/dist/lego2/Select';
import Textinput from '@crm/components/dist/lego2/Textinput';
import { InfiniteListView } from 'containers/InfiniteList';
import ClientSelectInputItemContainer from './ClientSelectInputItemContainer';
import css from './ClientSelectInput.modules.scss';
import config from './config';

const TYPE_SELECT_ITEMS = config.list.map((key) => ({
  value: key,
  content: config.map[key],
}));

class ClientSelectInput extends React.Component {
  static propTypes = {
    size: PropTypes.string,
    value: PropTypes.string,
    keys: PropTypes.instanceOf(Array).isRequired,
    onChangeValue: PropTypes.func.isRequired,
    onChangeKeys: PropTypes.func.isRequired,
    provider: PropTypes.func.isRequired,
    onChangeAccount: PropTypes.func.isRequired,
    onSelectAccount: PropTypes.func.isRequired,
    onSearch: PropTypes.func.isRequired,
    onKeyComponent: PropTypes.func.isRequired,
    onKeyValue: PropTypes.func.isRequired,
    accountId: PropTypes.number,
    disabled: PropTypes.bool,
    disabledKeys: PropTypes.bool,
    disabledFind: PropTypes.bool,
    isSearch: PropTypes.bool,
    autoFocus: PropTypes.bool,
  };

  static defaultProps = {
    size: 's',
    value: '',
    accountId: undefined,
    disabled: false,
    disabledKeys: false,
    disabledFind: false,
    isSearch: false,
    autoFocus: false,
  };

  constructor(props) {
    super(props);

    this.itemProps = {
      onClick: props.onSelectAccount,
    };
  }

  render() {
    const {
      size,
      value,
      keys,
      provider,
      onChangeValue,
      onChangeKeys,
      onChangeAccount,
      onSelectAccount,
      onKeyComponent,
      onKeyValue,
      onSearch,
      accountId,
      disabled,
      disabledKeys,
      disabledFind,
      isSearch,
      autoFocus,
    } = this.props;

    return (
      <span role="presentation" onKeyUp={onKeyComponent} className={css.ClientSelectInput__wrap}>
        <span className={css.ClientSelectInput}>
          <Select
            size={size}
            value={keys}
            hasEmptyValue={false}
            onChange={onChangeKeys}
            options={TYPE_SELECT_ITEMS}
            resetItem={config.resetItem}
            disabled={disabledKeys || disabled}
          />
          <Textinput
            onKeyUp={onKeyValue}
            onChange={onChangeValue}
            value={value}
            size={size}
            autoFocus={autoFocus}
            placeholder="Поиск аккаунта"
            disabled={disabled}
            pin="round-clear"
          />
          <Button
            size={size}
            view="action"
            onClick={onSearch}
            disabled={disabled || disabledFind}
            pin="clear-round"
          >
            Найти
          </Button>
        </span>
        {isSearch && (
          <InfiniteListView
            className={css.ClientSelectInput__list}
            onLoad={provider}
            component={ClientSelectInputItemContainer}
            name="CLIENT_SELECT_INPUT"
            selectedId={accountId}
            onChange={onChangeAccount}
            onItemClick={onSelectAccount}
            itemProps={this.itemProps}
            loadOnMount
            autoSelectFirst
            focusOnSelectFirst
            reloadOnLoadUpdate
          />
        )}
      </span>
    );
  }
}

export default ClientSelectInput;
