import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from './ClientSelectInput.modules.scss';

const ClientSelectInputItem = props => {
  const {
    data: { name, login, searchKeyName },
    selected,
    ...passPropsThrough
  } = props;

  let fullname = name;
  if (login) {
    fullname += ` (${login})`;
  }

  return (
    <div
      role="presentation"
      className={cx(css.ClientSelectInputItem, { [css.ClientSelectInputItem_selected]: selected })}
      {...passPropsThrough}
    >
      <div className={css.ClientSelectInputItem__hint}>
        <span className={css.ClientSelectInputItem__label}>Найдено по:&nbsp;</span>
        <span className={css.ClientSelectInputItem__key}>{searchKeyName}</span>
      </div>
      <div className={css.ClientSelectInputItem__name}>{fullname}</div>
    </div>
  );
};

ClientSelectInputItem.propTypes = {
  data: PropTypes.instanceOf(Object),
  selected: PropTypes.bool,
};

ClientSelectInputItem.defaultProps = {
  data: {},
  selected: false,
};

export default ClientSelectInputItem;
