import { Component, createElement } from 'react';
import PropTypes from 'prop-types';
import ClientSelectInputItem from './ClientSelectInputItem';

class ClientSelectInputItemContainer extends Component {
  static propTypes = {
    data: PropTypes.instanceOf(Object),
    onClick: PropTypes.func,
  };

  static defaultProps = {
    data: {},
    onClick: undefined,
  };

  handleClick = () => {
    const { onClick, data } = this.props;
    if (typeof onClick === 'function') {
      onClick(data);
    }
  }

  render() {
    return createElement(ClientSelectInputItem, { ...this.props, onClick: this.handleClick });
  }
}

export default ClientSelectInputItemContainer;
