import React, { Component, ReactNode } from 'react';
import Button from '@crm/components/dist/lego2/Button';
import { ContactCreateModal } from 'modules/contactCreateForm';
import { ContactCreateButtonProps } from './ContactCreateButton.types';

class ContactCreateButton extends Component<ContactCreateButtonProps> {
  private getContent = (): ReactNode => {
    const { children } = this.props;
    return children != null ? children : 'Создать';
  };

  private handleSubmitSuccess = (contact) => {
    const { onSubmitSuccess } = this.props;
    if (onSubmitSuccess) {
      onSubmitSuccess(contact);
    }
  };

  private handleClick = (): void => {
    const { accountId, formName } = this.props;
    ContactCreateModal.open({
      form: formName,
      accountId,
      onSubmitSuccess: this.handleSubmitSuccess,
    });
  };

  public render(): ReactNode {
    return (
      <Button size="xs" view="pseudo" onClick={this.handleClick} className={this.props.className}>
        {this.getContent()}
      </Button>
    );
  }
}

export default ContactCreateButton;
