import React from 'react';
import PropTypes from 'prop-types';
import { Row } from 'forms/Base';
import Button from '@crm/components/dist/lego2/Button';
import withDictionary from 'lego/components/withDictionary';
import Form from 'components/Form';
import css from './styles.modules.scss';

const Position = withDictionary({
  endpoint: '/view/dicts/position',
})(Row);

const Language = withDictionary({
  endpoint: '/view/dicts/language',
})(Row);

const getEmailFieldsArray = (isUseTagsForEmails = false) => {
  const fieldsArray = [
    {
      name: 'email',
      label: 'Email',
      component: 'TextInput',
    },
  ];
  if (isUseTagsForEmails) {
    fieldsArray.push({
      name: 'tags',
      label: 'Метки',
      component: 'SetTag',
      tagsType: 'ContactCommMediumLinkTag',
    });
  } else {
    fieldsArray.push({
      name: 'isBroadcast',
      children: 'Для рассылок',
      component: 'CheckBox',
    });
  }
  return fieldsArray;
};

const ContactCreateForm = (props) => {
  const {
    pristine,
    submitting,
    invalid,
    handleSubmit,
    emails,
    phones,
    isNew,
    onCancel,
    contactId,
    isUseTagsForEmails,
  } = props;
  let isEmailRequired = true;
  let isPhoneRequired = true;

  if (phones && phones.length && phones.some((item) => Boolean(item.phone))) {
    isEmailRequired = false;
  }

  if (emails && emails.length && emails.some((item) => Boolean(item.email))) {
    isPhoneRequired = false;
  }

  return (
    <Form theme={Form.THEME.MODAL} onSubmit={handleSubmit}>
      <Form.Header>{contactId ? 'Изменить контакт' : 'Новый контакт'}</Form.Header>
      <Form.Body>
        <Row component="TextInput" name="lastName" label="Фамилия" autoFocus />
        <Row component="TextInput" name="firstName" label="Имя" required />
        <Row component="TextInput" name="middleName" label="Отчество" />
        <Row component="CheckBox" name="isMain" label="Основной контакт" />
        <Position name="positionId" label="Должность" component="Select" isNullEmptyValue />
        <Row
          fieldClassName={css.birth_date}
          name="birthDate"
          label="Дата рождения"
          component="datePicker"
        />
        <Row
          name="emails"
          label="Email"
          required={isEmailRequired}
          component="fieldArray"
          fieldsArray={getEmailFieldsArray(isUseTagsForEmails)}
          withTags={isUseTagsForEmails}
        />
        <Row
          name="phones"
          label="Телефон"
          required={isPhoneRequired}
          component="fieldArray"
          fieldsArray={[
            {
              name: 'phone',
              label: 'Телефон',
              component: 'TextInput',
            },
            {
              name: 'phoneExt',
              label: 'Доб.',
              component: 'TextInput',
            },
          ]}
        />
        <Language
          name="languageId"
          label="Язык"
          component="Select"
          hasEmptyValue={false}
          isNullEmptyValue
        />
        <Row name="comment.text" label="Комментарий" component="TextArea" />
      </Form.Body>
      <Form.Footer>
        <Button
          size="m"
          type="submit"
          disabled={invalid || submitting || (!isNew ? pristine : undefined)}
          view="action"
        >
          Сохранить
        </Button>
        <Button size="m" onClick={onCancel}>
          Отменить
        </Button>
      </Form.Footer>
    </Form>
  );
};

ContactCreateForm.propTypes = {
  pristine: PropTypes.bool.isRequired,
  submitting: PropTypes.bool.isRequired,
  invalid: PropTypes.bool.isRequired,
  handleSubmit: PropTypes.func.isRequired,
  emails: PropTypes.arrayOf(PropTypes.instanceOf(Object)),
  phones: PropTypes.arrayOf(PropTypes.instanceOf(Object)),
  isNew: PropTypes.bool,
  onCancel: PropTypes.func,
  contactId: PropTypes.number,
};

ContactCreateForm.defaultProps = {
  emails: [{}],
  phones: [{}],
  isNew: undefined,
  onCancel: () => {},
  contactId: undefined,
};

export default ContactCreateForm;
