/*
eslint-disable no-underscore-dangle
*/

import { connect } from 'react-redux';
import get from 'lodash/get';
import { reduxForm, formValueSelector } from 'redux-form';
import { getFeatureFlag } from 'entry/store/selectors';
import * as patterns from 'requestForms/utils/patterns';
import { saveContact } from '../api';
import Form from '../components/Form/index';

const validate = (values) => {
  const errors = {};
  let hasEmailsError = false;
  let hasPhonesError = false;
  let isEmailsValid = true;
  let isPhonesValid = true;

  const validateEmails = () => {
    const emailsArrayErrors = [];

    values.emails.forEach((item, itemIndex) => {
      const itemErrors = {};

      if (!item.email) {
        itemErrors.email = 'Обязательно для запонения';
        emailsArrayErrors[itemIndex] = itemErrors;
      } else if (!patterns.email.test(item.email)) {
        itemErrors.email = 'Поле заполнено неправильно';
        emailsArrayErrors[itemIndex] = itemErrors;
        isEmailsValid = false;
      }
    });

    hasEmailsError = emailsArrayErrors.length;

    if (hasEmailsError) {
      errors.emails = emailsArrayErrors;
      errors._error = errors._error || {};
      errors._error.emails = true;
    }
  };

  const validatePhones = () => {
    const phonesArrayErrors = [];

    values.phones.forEach((item, itemIndex) => {
      const itemErrors = {};

      if (!item.phone) {
        itemErrors.phone = 'Обязательно для запонения';
        phonesArrayErrors[itemIndex] = itemErrors;
      } else if (!patterns.phone.test(item.phone)) {
        itemErrors.phone = 'Поле заполнено неправильно';
        phonesArrayErrors[itemIndex] = itemErrors;
        isPhonesValid = false;
      }

      if (item.phoneExt && !patterns.phoneExt.test(item.phoneExt)) {
        itemErrors.phoneExt = 'Поле заполнено неправильно';
        phonesArrayErrors[itemIndex] = itemErrors;
        isPhonesValid = false;
      }
    });

    hasPhonesError = phonesArrayErrors.length;

    if (hasPhonesError) {
      errors.phones = phonesArrayErrors;
      errors._error = errors._error || {};
      errors._error.phones = true;
    }
  };

  if (!values.firstName) {
    errors.firstName = 'Обязательно для заполнения';
  }

  if (!values.emails || !values.emails.length || !get(values.emails[0], 'email')) {
    errors._error = errors._error || {};
    errors._error.emails = true;
    hasEmailsError = true;
  }

  if (!values.phones || !values.phones.length || !get(values.phones[0], 'phone')) {
    errors._error = errors._error || {};
    errors._error.phones = true;
    hasPhonesError = true;
  }

  if (values.emails) {
    validateEmails();
  }

  if (values.phones) {
    validatePhones();
  }

  // Если emails заполнено правильно, то phones необязательное поле и наоборот;
  // при этом если необязательное заполнено, то оно должно соответствовать формату.
  if (!hasEmailsError && hasPhonesError && isPhonesValid) {
    delete errors._error.phones;
    delete errors.phones;
    hasPhonesError = false;
  }

  if (!hasPhonesError && hasEmailsError && isEmailsValid) {
    delete errors._error.emails;
    delete errors.emails;
    hasEmailsError = false;
  }

  if (errors._error && !Object.keys(errors._error).length) {
    delete errors._error;
  }

  return errors;
};

const mapState = (state, props) => {
  const selector = formValueSelector(props.form);
  const isUseTagsForEmails = getFeatureFlag(state, 'useTagsForEmails');
  const { emails, phones } = selector(state, 'emails', 'phones');

  const initEmails = get(props.initialValues, 'emails');
  const initPhones = get(props.initialValues, 'phones');

  const initialValues = {
    ...props.initialValues,
    emails: initEmails && initEmails.length ? initEmails : [{}],
    phones: initPhones && initPhones.length ? initPhones : [{}],
  };

  return {
    initialValues,
    emails,
    phones,
    isUseTagsForEmails,
  };
};

const mapDispatch = (dispatch, props) => ({
  onSubmit: (args) => {
    const { emails = [], phones = [] } = args;
    let resultEmails;
    let resultPhones;

    if (emails.length > 0) {
      const filteredEmails = emails.filter((item) => Boolean(item.email));

      if (filteredEmails.length > 0) {
        resultEmails = filteredEmails;
      }
    }

    if (phones.length > 0) {
      const filteredPhones = phones.length > 0 && phones.filter((item) => Boolean(item.phone));

      if (filteredPhones.length > 0) {
        resultPhones = filteredPhones;
      }
    }

    return saveContact({
      ...args,
      accountId: props.accountId,
      contactId: props.contactId,
      emails: resultEmails,
      phones: resultPhones,
    });
  },
});

export default connect(mapState, mapDispatch, null, { forwardRef: true })(
  reduxForm({ validate })(Form),
);
