import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Textinput from '@crm/components/dist/lego2/Textinput';
import Button from '@crm/components/dist/lego2/Button';
import Menu from '@crm/components/dist/lego2/Menu';
import Form from 'components/Form';
import css from './styles.modules.scss';

const renderItem = (item) => {
  const { name, position, email, phone } = item;

  const contacts = [];
  if (email) {
    contacts.push(email);
  }

  if (phone) {
    contacts.push(phone);
  }

  const right = contacts.join(', ');

  return (
    <span className={css.item}>
      <span className={css.left}>
        {name}&nbsp;
        {position && <span className={css.item__position}>({position})</span>}
      </span>
      <span className={css.right}>{right}</span>
    </span>
  );
};

class FormSelectContact extends Component {
  constructor(props) {
    super(props);

    this.state = {
      searchText: '',
    };
  }

  onSearchChange = (value) => {
    this.setState({ searchText: value });
    this.props.onSearch(value);
  };

  onSelect = (event) => {
    const { value } = event.target;
    this.props.onSelect((this.props.items || []).find((item) => item.contactId === value));
  };

  render() {
    const { searchFocused, items, selectedItem = {}, onCancel } = this.props;
    const { searchText } = this.state;

    return (
      <Form theme={Form.THEME.MODAL}>
        <Form.Header>Добавить контакт</Form.Header>
        <Form.Body className={css.body}>
          <Textinput
            autoFocus={searchFocused}
            name="search"
            placeholder="Имя, или фамилия, или email"
            size="m"
            value={this.state.searchText}
            onChange={this.onSearchChange}
          />
          {items && items.length > 0 && (
            <Menu
              className={css.list}
              size="m"
              value={selectedItem.contactId}
              onChange={this.onSelect}
              items={items.map((item) => ({
                value: item.contactId,
                content: renderItem(item),
              }))}
            />
          )}
          {(!items || !items.length) && searchText && searchText.length > 0 && (
            <div className={css.empty}>Контактов не найдено.</div>
          )}
        </Form.Body>
        <Form.Footer>
          <Button
            size="m"
            onClick={this.props.onSubmit}
            disabled={!selectedItem || !selectedItem.contactId}
            view="action"
          >
            Сохранить
          </Button>
          <Button size="m" onClick={onCancel}>
            Отменить
          </Button>
        </Form.Footer>
      </Form>
    );
  }
}

FormSelectContact.propTypes = {
  searchFocused: PropTypes.bool,
  selectedItem: PropTypes.shape({
    contactId: PropTypes.number,
    email: PropTypes.string,
  }),
  items: PropTypes.arrayOf(
    PropTypes.shape({
      contactId: PropTypes.number,
      email: PropTypes.string,
    }),
  ),
  onSearch: PropTypes.func,
  onSelect: PropTypes.func,
  onCancel: PropTypes.func,
  onSubmit: PropTypes.func.isRequired,
};

FormSelectContact.defaultProps = {
  searchFocused: true,
  selectedItem: undefined,
  items: undefined,
  onSearch: () => {},
  onSelect: () => {},
  onCancel: () => {},
};

export default FormSelectContact;
