import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';
import { toggle } from 'containers/Modal';
import { getContacts, saveContact } from './api';
import Form from './component';

class ContactForm extends Component {
  constructor(props) {
    super(props);

    this.state = {
      items: undefined,
      selectedItem: undefined,
    };
  }

  componentDidMount() {
    this.getContactsList();
  }

  onItemSelect = item => {
    this.setState({ selectedItem: item });
  };

  getContactsList = text => {
    this.props.getAccountContacts(text).then(data => {
      this.setState({ items: data.items });
    });
  };

  handleSubmit = () => {
    this.props.onSubmit(this.state.selectedItem.contactId);
  };

  render() {
    const { items, selectedItem } = this.state;

    return (
      <Form
        {...this.props}
        items={items}
        selectedItem={selectedItem}
        onSubmit={this.handleSubmit}
        onSearch={this.getContactsList}
        onSelect={this.onItemSelect}
      />
    );
  }
}

ContactForm.propTypes = {
  form: PropTypes.string.isRequired,
  accountId: PropTypes.number.isRequired,
  contact: PropTypes.instanceOf(Object).isRequired,
  getAccountContacts: PropTypes.func,
  onSubmit: PropTypes.func,
  onCancel: PropTypes.func,
};

ContactForm.defaultProps = {
  getAccountContacts: undefined,
  onSubmit: undefined,
  onCancel: undefined,
};

const mapDispatch = (dispatch, props) => ({
  getAccountContacts: text => getContacts({ accountId: props.accountId, text }),
  onSubmit: contactId => {
    const data = {
      accountId: props.accountId,
      email: props.contact.email,
      contactId,
    };

    saveContact(data).then(response => {
      if (response.success) {
        if (typeof props.onSuccess === 'function') {
          props.onSuccess(data);
        }
        dispatch(toggle(props.form, false));
      }
    });
  },
  onCancel: () => {
    if (typeof props.onCancel === 'function') {
      props.onCancel();
    }
    dispatch(toggle(props.form, false));
  },
});

export default connect(null, mapDispatch, null, { forwardRef: true })(ContactForm);
