import { GetCurrencyResponse } from './types';
const items = [
  {
    code: 'client',
    id: 0,
    name: 'Валюта клиента',
  },
  {
    code: 'rub',
    id: 1,
    name: 'Рубли',
  },
  {
    code: 'usd',
    id: 2,
    name: 'Доллары',
  },
  {
    code: 'eur',
    id: 6,
    name: 'Евро',
  },
];
const getCurrency = (id: number): GetCurrencyResponse => {
  return {
    // @ts-ignore
    currency: items.find((item) => item.id === id),
    items,
  };
};

export const getCurrencyRequest = (): Promise<GetCurrencyResponse> =>
  Promise.resolve(getCurrency(1));

export const setCurrencyRequest = (id: number): Promise<GetCurrencyResponse> =>
  Promise.resolve(getCurrency(id));
