import { connect } from 'react-redux';
import { ThunkDispatch } from 'redux-thunk';
import { Action } from 'redux';
import { ConnectedDispatchProps, ConnectedStateProps } from './CurrencySwitch.types';
import { Store } from '../../store/types';
import {
  getCurrentCurrency,
  getCurrencyCollection,
  getFetchingProcess,
} from '../../store/selectors';
import { getCurrencyThunk, setCurrencyThunk } from '../../store/thunk';

import CurrencySwitch from './CurrencySwitch';

const mapStateToProps = (state: Store): ConnectedStateProps => ({
  currentCurrency: getCurrentCurrency(state),
  currencyCollection: getCurrencyCollection(state),
  isFetching: getFetchingProcess(state),
});

const mapDispatchToProps = (
  dispatch: ThunkDispatch<Store, {}, Action>,
): ConnectedDispatchProps => ({
  getCurrency: () => {
    dispatch(getCurrencyThunk());
  },
  setCurrency: (id: number) => {
    dispatch(setCurrencyThunk(id));
  },
});

export default connect<ConnectedStateProps, ConnectedDispatchProps, {}, Store>(
  mapStateToProps,
  mapDispatchToProps,
)(CurrencySwitch);
