import React, { PureComponent, ReactNode } from 'react';
import Select from '@crm/components/dist/lego2/Select';
import { Option } from '@yandex-lego/components/Select/desktop';
import Spin from '@crm/components/dist/lego2/Spin';
import { SwitchCurrencyProps } from './CurrencySwitch.types';
import css from './CurrencySwitch.module.css';
import i18nKeySet from './CurrencySwitch.config';

export default class CurrencySwitch extends PureComponent<SwitchCurrencyProps> {
  private setValue = (value: string): void => {
    const agree = confirm(i18nKeySet.confirmMessage);
    if (agree) {
      this.props.setCurrency(Number(value));
    }
  };

  componentDidMount(): void {
    this.props.getCurrency();
  }

  private getOptions = (): Option[] => {
    return this.props.currencyCollection.map((cur) => ({
      value: String(cur.id),
      content: cur.name,
    }));
  };

  public render(): ReactNode {
    const options = this.getOptions();
    const current = this.props.currentCurrency;
    const { isFetching } = this.props;
    if (current === null) {
      return null;
    }
    return (
      <div className={css.b}>
        <span>{i18nKeySet.label}:</span>
        {isFetching ? (
          <Spin progress view="default" size="xxs" />
        ) : (
          <Select
            size="xs"
            view="default"
            onChange={this.setValue}
            value={String(current.id)}
            options={options}
            hasEmptyValue={false}
          />
        )}
      </div>
    );
  }
}
