import { createSlice, PayloadAction } from '@reduxjs/toolkit';
import { SLICE_NAME } from './constants';
import { InitialState, Currency } from './types';

const initialState: InitialState = {
  isFetching: false,
  current: null,
  collection: [],
};

export const CurrencySlice = createSlice({
  name: SLICE_NAME,
  initialState,
  reducers: {
    setCurrent: (state, { payload }: PayloadAction<Currency>) => {
      return {
        ...state,
        current: payload,
      };
    },

    setCollection: (state, { payload }: PayloadAction<Currency[]>) => {
      return {
        ...state,
        collection: payload,
      };
    },

    startFetch: (state) => {
      return {
        ...state,
        isFetching: true,
      };
    },

    finishFetch: (state) => {
      return {
        ...state,
        isFetching: false,
      };
    },
  },
});

export default CurrencySlice.reducer;
