import { Dispatch } from 'redux';
import { ThunkAction } from 'redux-thunk';
import { Action } from 'redux';
import actions from './actions';
import { Store } from './types';
import { getCurrencyRequest, setCurrencyRequest } from '../api';

export const getCurrencyThunk = (): ThunkAction<void, Store, {}, Action> => async (
  dispatch: Dispatch<Store>,
) => {
  dispatch(actions.startFetch());
  getCurrencyRequest()
    .then((res) => {
      dispatch(actions.setCurrent(res.currency));
      dispatch(actions.setCollection(res.items));
    })
    .finally(() => {
      dispatch(actions.finishFetch());
    });
};

export const setCurrencyThunk = (id: number): ThunkAction<void, Store, {}, Action> => async (
  dispatch: Dispatch<Store>,
) => {
  dispatch(actions.startFetch());
  setCurrencyRequest(id)
    .then((res) => {
      dispatch(actions.setCurrent(res.currency));
      dispatch(actions.setCollection(res.items));
      location.reload();
    })
    .finally(() => {
      dispatch(actions.finishFetch());
    });
};
