import { post } from 'api/common';
import * as t from './actionTypes';

export const enterDelegation = delegationId => ({
  type: 'PROMISE',
  actions: [t.DELEGATION_ENTER_REQUEST, t.DELEGATION_ENTER_RECEIVE, t.DELEGATION_ENTER_FAIL],
  promise: post({
    url: '/auth/login/asdelegated',
    host: global.CRM_SPACE_API_HOST,
    data: { delegationId },
  }),
});

export const exitDelegation = () => ({
  type: 'PROMISE',
  actions: [t.DELEGATION_EXIT_REQUEST, t.DELEGATION_EXIT_RECEIVE, t.DELEGATION_EXIT_FAIL],
  promise: post({
    url: '/auth/logout/asdelegated',
    host: global.CRM_SPACE_API_HOST,
    args: { exitDelegation: true },
  }),
});
