import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FormattedDate } from 'react-intl';
import cx from 'classnames';
import cssList from './styles/delegations.scss';
import cssAlias from './styles/alias.scss';

const formatDate = (date) => (
  <FormattedDate value={date} year="numeric" month="short" day="numeric" />
);

export default class DelegationsWidget extends Component {
  render() {
    const { delegations, user, realUser } = this.props;

    // eslint-disable-next-line no-nested-ternary
    return realUser.id ? (
      <div className={cssAlias.root}>
        <div className={cssAlias.header}>
          Вы работаете как
          <div className={cssAlias.name}>{user.name}</div>
          {user.position && (
            <div className={cssAlias.position}>{`Роль Стафф: ${user.position}`}</div>
          )}
          {user.mainRoleName && (
            <div className={cssAlias.position}>{`Роль CRM: ${user.mainRoleName}`}</div>
          )}
          <a className={cssAlias.exit} tabIndex="0" onClick={this.props.onExit}>
            Вернуться в свой аккаунт
            <i className={cx('material-icons', cssAlias.exitIcon)}>assignment_return</i>
          </a>
        </div>
      </div>
    ) : delegations.length ? (
      <div className={cssList.root}>
        <div className={cssList.header}>Делегирования</div>
        <div className={cssList.list}>
          {delegations.map((item) => {
            return (
              <div key={item.delegationId} className={cssList.listItem}>
                <a
                  className={cssList.name}
                  title={`Войти как ${item.delegatorUser && item.delegatorUser.name}`}
                  tabIndex="0"
                  onClick={() => {
                    this.props.onEnter(item);
                  }}
                >
                  <i className={cx('material-icons', cssList.icon)}>assignment_ind</i>
                  {item.delegatorUser && item.delegatorUser.name}
                </a>
                <div className={cssList.date}>
                  <span className={cssList.from}>{formatDate(item.startDate)}</span>
                  &nbsp;–&nbsp;
                  <span className={cssList.to}>{formatDate(item.endDate)}</span>
                </div>
              </div>
            );
          })}
        </div>
      </div>
    ) : null;
  }
}

DelegationsWidget.propTypes = {
  delegations: PropTypes.arrayOf(
    PropTypes.shape({
      delegationId: PropTypes.Number,
      delegatorUser: PropTypes.instanceOf(Object),
      startDate: PropTypes.string,
      endDate: PropTypes.string,
    }),
  ),
  user: PropTypes.shape({
    id: PropTypes.Number,
    login: PropTypes.string,
    name: PropTypes.string,
    position: PropTypes.string,
  }),
  realUser: PropTypes.shape({
    id: PropTypes.Number,
    login: PropTypes.string,
    name: PropTypes.string,
    position: PropTypes.string,
  }),
};

DelegationsWidget.defaultProps = {
  delegations: [],
  user: {},
  realUser: {},
};
