import { connect } from 'react-redux';
import * as actions from './actions';
import Delegations from './component';

export default connect(
  null,
  dispatch => ({
    onEnter: item => dispatch(actions.enterDelegation(item.delegationId))
      .then(() => {
        global.location.reload();
      }),
    onExit: () => dispatch(actions.exitDelegation())
      .then(() => {
        global.location.reload();
      }),
  }),
)(Delegations);
