const checkCookie = (name) => {
  const matches = document.cookie.match(
    new RegExp('(?:^|; )' + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + '=([^;]*)'),
  );
  return matches ? decodeURIComponent(matches[1]) : undefined;
};

let isDelagation;
const checkDelegation = (args = {}) => {
  const hasDelegationCookie = checkCookie('delegationId');

  if (hasDelegationCookie && !isDelagation) {
    isDelagation = true;
  }

  if (isDelagation && !hasDelegationCookie) {
    isDelagation = false;

    if (!args.exitDelegation && !document.hidden) {
      alert(
        'Делегирование закончилось или было отозвано. Вы будете перенаправлены в свой аккаунт.',
      );
      window.location.reload();
    }
  }
};

export default checkDelegation;
