import React from 'react';

interface Props {
  mailId: number;
  requestId?: number;
  ticketId?: number;
  open: () => void;
  onSubmitSuccess?: () => void;
  component: React.ComponentType<{}>;
}

const DetachTicketToggle: React.FC<Props> = props => {
  const {
    component: Component = 'span',
    open,
    mailId,
    requestId,
    ticketId,
    onSubmitSuccess,
    ...passThroughProps
  } = props;

  return (
    <Component
      title="Отделить"
      {...passThroughProps}
      onClick={e => {
        open();
        e.stopPropagation();
      }}
    >
      <i className="fa fa-code-fork" />
    </Component>
  );
};

export default DetachTicketToggle;
