import React, { Component } from 'react';
import Spinner from 'components/Spinner';
import FormView from './FormView';
import { FormValues } from '../types';

const spinner = (
  <Spinner
    visible
    modal={false}
    overlay
    delay={false}
    style={{
      width: 300,
      height: 200,
    }}
  />
);

interface Props {
  isLoad: boolean;
  data?: Partial<FormValues>;
  destroy: () => void;
  loadData: () => void;
  onSubmit: (values: FormValues) => void;
}

export default class DetachTicketController extends Component<Props> {
  public componentDidMount() {
    this.props.loadData();
  }

  public componentWillUnmount() {
    this.props.destroy();
  }

  public render() {
    if (!this.props.isLoad) {
      return spinner;
    }

    return <FormView {...this.props} initialValues={this.props.data} form="detachTicket" />;
  }
}
