import { connect } from 'react-redux';
import get from 'lodash/get';
import formSlice from '../formSlice';
import FormController from './FormController';
import { FormValues } from '../types';

interface ConnectedState {
  isLoad: boolean;
  data?: Partial<FormValues>;
}

interface ConnectedDispatch {
  destroy: () => void;
  loadData: () => void;
  onSubmit: (values: FormValues) => void;
}

interface Props {
  mailId: number;
  ticketId?: number;
  requestId?: number;
  issueId?: number;
  onSubmit?: (values: FormValues) => void;
}

const mapState = state => ({ ...get(state, 'detachTicket') });

export default connect<ConnectedState, ConnectedDispatch, Props>(mapState, (dispatch, props) => ({
  loadData: () => {
    dispatch(
      formSlice.actions.loadData({
        mailId: props.mailId,
        requestId: props.requestId,
        ticketId: props.ticketId,
        issueId: props.issueId,
      }),
    );
  },
  onSubmit:
    props.onSubmit ||
    ((values: FormValues) => {
      dispatch(
        formSlice.actions.detach({
          accountId: get(values, 'account.id'),
          queueId: get(values, 'queue.id'),
          categoryId: get(values, 'category.id'),
          mailId: props.mailId,
          requestId: props.requestId,
          ticketId: props.ticketId,
        }),
      );
    }),
  destroy: () => {
    dispatch(formSlice.actions.destroy());
  },
}))(FormController);
