import React from 'react';
import { reduxForm, InjectedFormProps } from 'redux-form';
import * as Form from 'forms/Base';
import { FormValues } from '../types';

const requiredFields = ['account', 'category', 'queue'];

const validate = (values: Partial<FormValues>) => {
  const errors = {};

  requiredFields.forEach((field) => {
    if (!values[field]) {
      errors[field] = 'required'; // eslint-disable-line no-underscore-dangle
    }
  });

  return errors;
};

interface Props {
  onCancel?: () => void;
  eId?: number;
  eType?: string;
  workplace?: string;
}

const DetachTicket: React.FC<Props & InjectedFormProps<FormValues, Props>> = (props) => {
  const { onCancel, valid, submitting, handleSubmit, eId, eType, workplace } = props;
  return (
    <Form.Form onSubmit={handleSubmit} title="Отделить">
      <Form.Row name="account" component="client" label="Клиент" required />
      <Form.Row
        label="Категория"
        component="category"
        name="category"
        required
        workplace={workplace}
        eId={eId}
        eType={eType}
      />
      <Form.Row label="Очередь" component="queue" name="queue" required />
      <Form.Footer
        submitText="Отделить"
        submitProps={{
          disabled: !valid || submitting,
        }}
        cancelProps={{
          onClick: onCancel,
        }}
      />
    </Form.Form>
  );
};

export default reduxForm<FormValues, Props>({ validate })(DetachTicket);
