/* eslint-disable no-param-reassign */
import { createSlice } from '@reduxjs/toolkit';
import { baseCallApi, jsonApiCall } from 'api/common';

const convertBackendData = data => ({
  ...data,
  account: data.account && data.account.info,
});

interface SliceState {
  isLoad: boolean;
  data?: any;
}

const initState: SliceState = { isLoad: false };

const formSlice = createSlice({
  name: 'counter',
  initialState: initState,
  reducers: {
    getDataRequest(state) {
      state.isLoad = false;
    },
    getDataSuccess(state, { payload }) {
      return {
        isLoad: true,
        data: convertBackendData(payload),
      };
    },
    getDataFailed(state) {
      state.isLoad = false;
    },
    destroy() {
      return {
        isLoad: false,
      };
    },
  },
});

const loadData = (args): any => dispatch => {
  dispatch(formSlice.actions.getDataRequest());
  return baseCallApi({ url: '/view/support/mail/detach', global: false, data: args })
    .then(data => {
      dispatch(formSlice.actions.getDataSuccess(data));
      return data;
    })
    .catch(() => {
      dispatch(formSlice.actions.getDataFailed());
    });
};

const detach = (args): any => () => {
  return jsonApiCall({ url: '/action/support/mail/detach', global: false, data: args });
};

export default { ...formSlice, actions: { ...formSlice.actions, loadData, detach } };
