export interface Account {
  id: number;
  info: {
    id: number;
    name: string;
  };
}

export interface GetDetachDataRequest {
  mailId: number;
  ticketId?: number;
  requestId?: number;
}

export interface GetDetachDataResponse {
  account?: Account;
  queue?: { id: number; name: string };
  category?: { id: number; name: string; fullPath: string };
}

export interface FormValues {
  account: { id: number; name: string };
  queue: { id: number; name: string };
  category: { id: number; name: string; fullPath: string };
}

export interface SaveDetachRequest {
  accountId: number;
  queueId: number;
  categoryId: number;
  mailId: number;
  ticketId?: number;
  requestId?: number;
}

/* export interface SaveDetachResponse {
  // ???
} */
