import React, { useEffect, useState, FC } from 'react';
import { get } from 'api/common';
import Spin from '@crm/components/dist/lego2/Spin';
import { config } from 'services/Config';
import { TABS_SOURCE } from './Layout.constants';
import { Tabs } from '../Tabs';
import { FetchTabsResponse, Tab } from './Layout.types';

export const Layout: FC = () => {
  const [tabs, setTabs] = useState<Tab[] | undefined>();
  const [tabsLoading, setTabsLoading] = useState(false);

  useEffect(() => {
    setTabsLoading(true);

    get<FetchTabsResponse>({ url: TABS_SOURCE })
      .then(({ data }) => {
        setTabs(data.tabs);
      })
      .finally(() => {
        setTabsLoading(false);
      });
  }, []);

  if (tabsLoading && config.value.features.newDesignLift) {
    return <Spin view="default" position="center" progress size="l" />;
  }

  if (!tabs) {
    return null;
  }

  return <Tabs tabs={tabs} />;
};
