import React, { FC } from 'react';
import { LayoutBuilderByScheme } from 'components/LayoutBuilderByScheme';
import { LinkTab, LinkTabs, ThemeType } from 'lego/components/Tabs';
import isEmpty from 'lodash/isEmpty';
import css from './Tabs.module.css';
import { TabsProps } from './Tabs.types';
import { ROUTE_PATH } from '../../constants';

export const Tabs: FC<TabsProps> = ({ tabs }) => {
  if (!Array.isArray(tabs) || isEmpty(tabs)) {
    return null;
  }
  return (
    <LinkTabs
      className={css.b}
      theme={ThemeType.Icon}
      classNameHeader={css.b__header}
      navigationTheme="start"
      redirectUrl={`${ROUTE_PATH}/${tabs[0].tabId}`}
    >
      {tabs.map((tab) => (
        <LinkTab
          key={tab.tabId}
          path={`${ROUTE_PATH}/${tab.tabId}`}
          title={tab.tabCaption}
          className={css.b__tabContent}
        >
          <LayoutBuilderByScheme
            className={css.Layout__grid}
            blocks={tab.blocks}
            layout={tab.layout}
          />
        </LinkTab>
      ))}
    </LinkTabs>
  );
};
