import { Table } from 'components/Table/Table.types';
import { Tab } from 'types/api/Tabs';

export const BLOCK1_SOURCE = '/testBlock1/tableWithFilters';
export const BLOCK2_SOURCE = '/testBlock2/tableWithFilters';

export const tabsData: Tab[] = [
  {
    tabId: 1,
    tabCaption: 'TestCaption1',
    blocks: {
      1: {
        componentType: 'TableWithFilters',
        title: 'BlockCaption1',
        url: BLOCK1_SOURCE,
      },
    },
    layout: {
      areaIdToBlocksIds: { 1: ['1'] },
      schema: {
        rows: [{ areaId: '1', blockWidthRatio: 1 }],
      },
    },
  },
  {
    tabId: 2,
    tabCaption: 'TestCaption2',
    blocks: {
      2: {
        componentType: 'TableWithFilters',
        title: 'Мои контрагенты',
        url: BLOCK2_SOURCE,
      },
    },
    layout: {
      areaIdToBlocksIds: { 1: ['2'] },
      schema: {
        rows: [{ areaId: '1', blockWidthRatio: 1 }],
      },
    },
  },
];

export const tableData1: Table = {
  meta: {
    fieldsVisibility: ['someId1'],
    fields: [
      {
        id: 'someId1',
        sortable: false,
        title: 'SomeText',
        type: 'Text',
        isPinned: false,
        access: 3,
        isFieldsUpdateNeeded: false,
      },
    ],
  },
  data: [
    {
      id: 'id1',
      fields: [
        {
          id: 'someId1',
          type: 'Text',
          data: { value: 'Text Value 1' },
        },
      ],
    },
  ],
};

export const tableData2: Table = {
  meta: {
    fieldsVisibility: ['someId1'],
    fields: [
      {
        id: 'someId1',
        sortable: false,
        title: 'SomeText',
        type: 'Text',
        isPinned: false,
        access: 3,
        isFieldsUpdateNeeded: false,
      },
    ],
  },
  data: [
    {
      id: 'id1',
      fields: [
        {
          id: 'someId1',
          type: 'Text',
          data: { value: 'Text Value 2' },
        },
      ],
    },
  ],
};
