import { connect } from 'react-redux';
import PropTypes from 'prop-types';
import { setFilter as setFilterAction } from './actions';
import { getFilter } from './selectors';

const FilterSetter = ({ render, ...other }) => render(other);

FilterSetter.propTypes = {
  render: PropTypes.func.isRequired,
  setFilter: PropTypes.func.isRequired,
  name: PropTypes.string.isRequired,
};

const mapState = (_, props) => state => ({
  filter: getFilter(state, props.name, props.filterKey),
});

const mapDispatch = (_, props) => dispatch => ({
  setFilter: filterObj => dispatch(setFilterAction(
    props.name,
    {
      key: props.filterKey,
      ...filterObj,
      isStore: props.isStore,
      isActive: props.isActive,
    },
    false,
  )),
});

export default connect(mapState, mapDispatch)(FilterSetter);
