import * as actionTypes from './actionTypes';

export const setFilter = (name, filter, isActiveFilter = true) =>
  ({
    type: actionTypes.SET_FILTER,
    payload: filter,
    meta: { name },
    isActiveFilter,
  });

export const removeFilter = (name, filterKey) =>
  ({ type: actionTypes.REMOVE_FILTER, payload: filterKey, meta: { name } });

export const destroy = name =>
  ({ type: actionTypes.DESTROY, meta: { name } });
