import arrayReducerFactoryRaw from 'utils/reducer/arrayReducerFactoryRaw';
import * as aTypes from './actionTypes';

const INIT = {
  filters: {},
  activeFilter: 'default',
};

const behaviors = {
  [aTypes.SET_FILTER](state, { payload, isActiveFilter }) {
    const newState = {
      ...state,
      filters: {
        ...state.filters,
        [payload.key]: payload,
      },
    };

    if (isActiveFilter) {
      newState.activeFilter = payload.key;
    }

    return newState;
  },
  [aTypes.REMOVE_FILTER](state, { payload }) {
    const currentFilter = state.activeFilter;
    const newState = {
      ...state,
      filters: { ...state.filters },
    };
    if (payload === currentFilter) {
      newState.activeFilter = 'default';
    }
    delete newState.filters[payload];
    return newState;
  },
  [aTypes.DESTROY](state) {
    const { filters } = state;
    let storeFiltersCount = 0;
    const storeFilters = {};
    Object.keys(filters).forEach((key) => {
      const filter = filters[key];
      if (filter && filter.isStore) {
        storeFiltersCount += 1;
        storeFilters[key] = filter;
      }
    });

    if (storeFiltersCount) {
      return { filters: storeFilters };
    }

    return undefined;
  },
};

export default arrayReducerFactoryRaw(aTypes, behaviors, INIT);
