import get from 'lodash/get';
import { NAME } from './constants';

export const getFilterState = (state, name) => get(state, `${NAME}.${name}`);
export const getFilter = (state, name, filterKey) =>
  get(getFilterState(state, name), `filters[${filterKey}]`);
export const getActiveFilterKey = (state, name) => get(getFilterState(state, name), 'activeFilter');
export const getActiveFilter = (state, name) => {
  const filterState = getFilterState(state, name);
  return get(filterState, `filters[${get(filterState, 'activeFilter')}]`);
};
