import { connect } from 'react-redux';
import { Group } from 'components/Group';
import get from 'lodash/get';
import { DEFAULT_GROUP_NAME } from '../constants';
import redux from '../redux';

const mapState = (state, props) => {
  const groupsState = redux.selectors.getState(state);

  return {
    show:
      get(groupsState, [props.groupName, 'forceToggle']) ||
      get(groupsState, [props.groupName, 'state', props.name]),
  };
};

const mapDispatch = (dispatch, props) => ({
  onToggle: () => dispatch(redux.actions.toggle(props.groupName, props.name)),
});

const ConnectedGroup = connect(
  mapState,
  mapDispatch,
)(Group);

ConnectedGroup.defaultProps = {
  groupName: DEFAULT_GROUP_NAME,
};

export default ConnectedGroup;
