import * as React from 'react';
import { connect } from 'react-redux';
import { DEFAULT_GROUP_NAME } from '../constants';
import redux from '../redux';

interface Props {
  show: boolean;
  forceToggle: (name: string) => void;
  destroy: (name: string) => void;
  name: string;
  children: React.ReactNode;
}

class ProviderGroup extends React.Component<Props> {
  public static defaultProps = {
    name: DEFAULT_GROUP_NAME,
  };

  public componentDidUpdate(prevProps) {
    if (this.props.show !== prevProps.show) {
      this.props.forceToggle(this.props.name);
    }
  }

  public componentWillUnmount() {
    this.props.destroy(this.props.name);
  }

  public render() {
    return React.Children.only(this.props.children);
  }
}

export default connect(
  null,
  { forceToggle: redux.actions.forceToggle, destroy: redux.actions.destroy },
)(ProviderGroup);
