import arrayReducerFactoryRaw from 'utils/reducer/arrayReducerFactoryRaw';
import { TOGGLE, FORCE_TOGGLE, DESTROY } from './actionTypes';

const INIT = {
  forceToggle: false,
  state: {},
};

const behaviors = {
  [TOGGLE](state, { payload }) {
    return {
      ...state,
      state: {
        ...state.state,
        [payload]: !state.state[payload],
      },
    };
  },
  [FORCE_TOGGLE](state) {
    return { ...state, forceToggle: !state.forceToggle };
  },
  [DESTROY](state) {
    return { ...state, forceToggle: false };
  },
  LOCAL_STORAGE(state) {
    const subState = { ...state };
    delete subState.forceToggle;
    return subState;
  },
};

export default arrayReducerFactoryRaw(null, behaviors, INIT);
