import { createContext } from 'react';

let chain = ['CRM Space'];

const compile = (separator = ' — ') => {
  document.title = chain.join(separator);
};

const HeadingContext = createContext({
  chain,
  push: value => {
    if (chain.indexOf(value) === -1) chain.unshift(value);
    compile();
  },
  pull: value => {
    chain = chain.filter(item => item !== value);
    compile();
  },
  compile,
});

export default HeadingContext;
